;								EJEMPLO 31
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;Los mdulos CCPx. Modo de Comparacin. 
;
;El TMR1 cuenta tantos pulsos externos como se indique mediante los interruptores conectados a
;RA5-RA0 del laboratorio PIC'School. Cada vez que se alcanza el valor fijado, la salida RB0
;cambia de estado.
		
		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

			__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC

			org	0x00		;Vector de RESET	
			goto	Inicio
			org	0x04		;Vector de interrupcin
			goto	Inter
			org	0x05
		
;Programa de tratamiento de la interrupcin que provoca el mdulo CCP1 cada vez que el TMR1
;cuenta tantos pulsos externos como los prefijados mediante las entradas RA5-RA0.

Inter		bcf		PIR1,CCP1IF		;Repone el flag del mdulo CCP1
			bcf		T1CON,TMR1ON	;TMR1 en Off
			clrf	TMR1L
			clrf	TMR1H			;Puesta a 0 del TMR1
			movlw	b'00000001'
			xorwf	PORTB,F			;RB0 cambia de estado
			bsf		T1CON,TMR1ON	;TMR1 en On
			retfie		

;Programa principal

Inicio	  	clrf	PORTB		;Desconecta salidas
			clrf	PORTA
			bsf		STATUS,RP0	;Selecciona banco 1
			movlw	b'00000110'
			movwf	ADCON1		;Puerta A E/S digitales
			clrf	TRISB		;Puerta B se configura como salida
			movlw	b'00111111'
			movwf	TRISA		;Puerta A entradas
			movwf	TRISC		;RC0 entrada
			bsf		PIE1,CCP1IE	;Habilita interrupcin del mdulo CCP1
			bcf		STATUS,RP0	;Selecciona banco 0
	
;El TMR1 acta en el modo contador de pulsos externos sensible al flanco ascendente y con
;un preescaler de 1:1. Estos pulsos pueden ser suministrador por el generador del laboratorio

			movlw	b'00000010'
			movwf	T1CON		;TMR1 en Off		
			movlw	b'11000000'
			movwf	INTCON		;Habilita interrupciones

;El mdulo CCP1 acta en modo de comparacin e interrupcin al coincidir

			movlw	b'00001010'
			movwf	CCP1CON			;Mdulo CCP en modo comparacin		
			clrf	CCPR1H			;Puesta a 0 de la parte alta del valor a comparar
			clrf	TMR1L
			clrf	TMR1H			;Puesta a 0 del TMR1
			bsf		T1CON,TMR1ON	;TMR1 en On, comienza a contar

Loop		clrf	CCPR1H		;Pone a 0 la parte alta del valor a comparar
			movf	PORTA,W
			andlw	b'00111111'	;Lee las entradas RA5-RA0
			movwf	CCPR1L		;Ajusta la parte baja del valor a comparar
			goto	Loop		;Bucle infinito		

			end					;Fin del programa fuente
		
